import matplotlib.pyplot as plt

def draw(
        values:list
):
    bar_width = 0.4
    offset = 9

    positions = []
    for i in range(3):
        for j in range(10):
            positions.append((i+1)*offset-3*bar_width+j*2*bar_width)


    color = ['#008000', '#F0E68C', '#808080','#000080' ,'#ADD8E6','#D2B48C','#808000','#DAA520','#C1F80A','#D2691E']
    plt.bar(positions, values, color=color, edgecolor='black', linewidth=2)

    legend_labels = ['OWA', 'R', 'Ada','GOK','EAE','UCB','MOT','MPC', 'S-OWA','A-OWA']
    legend_handles = [plt.Line2D([0], [0], color=color, linewidth=3, linestyle='-') for color in
                      color]
    plt.legend(legend_handles, legend_labels, loc='upper center', bbox_to_anchor=(0.5, 1.15),
               fancybox=True, shadow=True, ncol=5, fontsize=10)


    plt.xlabel(r"$K$ (kJ)", fontsize=12)
    plt.ylabel(r"Accumulated Accuracy", fontsize=12)
    plt.grid(axis='y', linestyle='--', alpha=0.7)

    plt.xticks([(i+1.275)*offset for i in range(3)], ['8', '9', '10'],fontsize=10)
    figure = plt.gcf()
    figure.savefig("Set2-3.pdf")
    plt.show()

if __name__ == '__main__':
    OWA = [253.6295884659873, 0.0, 267.99379564028357, 0.0, 0.0, 273.3941447667483]
    Random = [209.90923667073565, 0.0, 209.76480290562296, 0.0, 0.0, 208.5179062105155]
    Adaptive = [215.74089953276263, 0.0, 226.8707123716155, 0.0, 0.0, 251.90610594186722]
    SingleOLS = [207.6278615537974, 0.0, 229.80707296226552, 0.0, 0.0, 246.03361456329847]
    MAB = [107.87823581048971, 0.0, 107.87823581048971, 0.0, 0.0, 107.87823581048971]
    GOK = [128.62775365047577, 0.0, 128.62775365047577, 0.0, 0.0, 128.62775365047577]
    MPC = [128.62775365047577, 0.0, 172.30536224494568, 0.0, 0.0, 215.98297083941557]
    UBC = [114.59474264908765, 0.0, 114.59474264908765, 0.0, 0.0, 114.59474264908765]
    AvgM = [135.04163463504742, 0.0, 137.22077122255186, 0.0, 0.0, 138.31505834642508]
    OTP = [155.37924216784188,0.0,174.83480870578595,0.0,0.0,200.99641918517247]
    rows = [OWA, Random, Adaptive, GOK, MAB, UBC, OTP, MPC, SingleOLS, AvgM]
    data = []
    for j in range(3):
        if j==0:
            for i in rows:
                data.append(i[0])
        if j==2:
            for i in rows:
                data.append(i[-1])
        if j==1:
            for i in rows:
                data.append((i[2]+i[3])/2)
    print(len(data))
    draw(data)